﻿using System.Collections.ObjectModel;
using RssReader.BusinessLogic;

namespace RssReader.ViewModels
{
    public class MainViewModel : ViewModelBase
    {
        private readonly RssFeedReader _rssReader;

        public ObservableCollection<RssItemViewModel> Items { get; set; }

        public RssItemViewModel SelectedItem { get; set; }

        public MainViewModel()
        {
            _rssReader = new RssFeedReader();
            Items = new ObservableCollection<RssItemViewModel>();
            _rssReader.RssItemLoaded += RssReader_RssItemLoaded;
            LoadRssFeed();
        }

        void RssReader_RssItemLoaded(object sender, RssItemEventArgs e)
        {
            Dispatcher.BeginInvoke(delegate
            {
                var rssViewModel = new RssItemViewModel
                                       {
                                           Title = e.Item.Title,
                                           Description = e.Item.Title,
                                           Link = e.Item.Link,
                                           ImageLink = e.Item.ImageLink,
                                           DatePublished = e.Item.DatePublished
                                       };
                Items.Add(rssViewModel);
            });
        }

        public void LoadRssFeed()
        {
            _rssReader.LoadRssFeed("http://www.20min.ch/rss/rss.tmpl?type=channel&get=1");
        }
    }
}
